//
//  GSComponent.h
//  Glyphs
//
//  Created by Georg Seifert on 30.3.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
@class GSGlyph;
@class GSFont;
@class GSLayer;
@class SCEvents;
#ifndef GLYPHS_VIEWER
#import <GlyphsCore/SCEventListenerProtocol.h>
#endif
/*! \brief GSComponent: The class defining the component object
 \ingroup common
 This class defines the component object. It is a subclass of GSElement
 */
@interface GSBackgroundImage : GSElement 
#ifndef GLYPHS_VIEWER
<SCEventListenerProtocol>
#endif
{
	//NSURL							*imageURL;
	NSString						*_imagePath;
	NSImage							*_image;
	@public NSAffineTransformStruct _transformStruct;
	NSRect							_crop;
	BOOL							_locked;
#ifndef GLYPHS_VIEWER
	NSDate							*_imageFileDate;
#endif
	BOOL							_didAsk;
	BOOL							_didLoad;
#ifndef GLYPHS_VIEWER
	SCEvents*						_events;
#endif
}

//* @name Initialisation*/
/// Inits with a NSURL 
- (id) initWithURL: (NSURL*) URL ;
/// Inits with a path 
- (id) initWithPath: (NSString*) Path ;

/// the image path
@property(strong, nonatomic) NSString	*imagePath;
/// the NSImage
@property(strong, nonatomic) NSImage *image ;
/// The Crop
@property(assign, nonatomic)	NSRect	crop;
/// if the image is looked
@property(assign, nonatomic)	BOOL	locked;

/** The transformation of the component.

 The values of the struct are:
 {m11, m12, m21, m22, tX, tY}
 this is equivalent to the glif attributes
 {xScale, xyScale, yxScale, yScale, xOffset, yOffset}
 in the same order.
 The initial value is {1,0,0,1,0,0}.
 */
@property(assign, nonatomic) NSAffineTransformStruct transformStruct;

/// Shows the image in the Finder
- (void) showInFinder:(id) sender ;
/// toggle locked
- (void) toggleLocked ;
- (BOOL) hasImageToDraw;
@end
